
-- Récupération et transfert des logins locaux dans un environnement Always On
-- Cette requête génère les instructions "CREATE LOGIN" pour réimporter, dans un autre nœud Always On,
-- les logins présents localement sur le nœud source, en conservant leurs mots de passe hachés et leurs SIDs.
-- L'objectif est de faciliter la synchronisation des logins entre plusieurs serveurs liés par Always On,
-- évitant ainsi les désynchronisations de comptes et l'obligation de réinitialiser les mots de passe.

SELECT 
    N'CREATE LOGIN [' + sp.[name] + '] WITH PASSWORD=0x'
    + CONVERT(nvarchar(max), l.password_hash, 2)
    + N' HASHED, CHECK_POLICY=OFF, '
    + N'SID=0x' + CONVERT(nvarchar(max), sp.[sid], 2)
    + N';'
FROM master.sys.server_principals AS sp
INNER JOIN master.sys.sql_logins AS l ON sp.[sid]=l.[sid]
WHERE sp.[type]='S' -- Logins SQL uniquement (type='S')
  AND sp.is_disabled=0; -- Logins actifs

